//
//  GlyphsFilterOffsetCurve.h
//  GlyphsFilterOffsetCurve
//
//  Created by Georg Seifert on 13.1.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSFilterPlugin.h>
#import <GlyphsCore/GSMetricValue.h>
#import <GlyphsCore/GSPath.h>

@class GSLayer;

@interface GSPath (expandStrokes)
- (NSArray *)expandedStroke;
@end

@interface GlyphsFilterOffsetCurve : GSFilterPlugin

@property (nonatomic, weak) IBOutlet NSTextField *offsetXField;
@property (nonatomic, weak) IBOutlet NSTextField *offsetYField;
@property (nonatomic, weak) IBOutlet NSButton *proportionalButton;
@property (nonatomic, weak) IBOutlet NSButton *makeStrokeButton;
@property (nonatomic, weak) IBOutlet NSButton *autoStrokeButton;
@property (nonatomic, weak) IBOutlet NSTextField *positionTextField;
@property (nonatomic, weak) IBOutlet NSTextField *positionLabel;
@property (nonatomic, weak) IBOutlet NSSegmentedControl *capStyleButton;
@property (nonatomic, weak) IBOutlet NSButton *keepCompatibleCheckbox;

//@property float radius;
- (IBAction)setOffsetX:(id)sender;
- (IBAction)setOffsetY:(id)sender;
- (IBAction)setProportional:(id)sender;
- (IBAction)setMakeStroke:(id)sender;
- (IBAction)setAutoStroke:(id)sender;
- (IBAction)setPosition:(id)sender;
- (IBAction)setCapStyle:(id)sender;
- (IBAction)setKeepCompatible:(id)sender;

+ (NSInteger)makeStroke:(GSLayer *)layer offsetX:(CGFloat)offsetX offsetY:(CGFloat)offsetY capStyleStart:(GSLineCapStyle)capStyleStart capStyleEnd:(GSLineCapStyle)capStyleEnd;

+ (NSInteger)offsetLayer:(GSLayer *)layer offsetX:(CGFloat)offsetX offsetY:(CGFloat)offsetY makeStroke:(BOOL)makeStroke autoStroke:(BOOL)autoStroke position:(float)position metrics:(NSArray<GSMetricValue *> *)metrics error:(NSError **)error shadow:(GSLayer *)shadowLayer capStyleStart:(GSLineCapStyle)capStyleStart capStyleEnd:(GSLineCapStyle)capStyleEnd keepCompatibleOutlines:(BOOL)keepCompatible;

+ (NSArray *)offsetPath:(GSPath *)currPath offsetX:(CGFloat)offsetX offsetY:(CGFloat)offsetY makeStroke:(BOOL)makeStroke position:(float)position objects:(NSMutableArray *)returnObjects __attribute((deprecated("use method `offsetPath:offsetX:offsetY:makeStroke:position:objects:capStyleStart:capStyleEnd:` instead")));

+ (NSArray *)offsetPath:(GSPath *)currPath offsetX:(CGFloat)offsetX offsetY:(CGFloat)offsetY makeStroke:(BOOL)makeStroke position:(float)position objects:(NSMutableArray *)returnObjects capStyleStart:(GSLineCapStyle)capStyleStart capStyleEnd:(GSLineCapStyle)capStyleEnd;

// compatibility
+ (NSArray *)offsetPath:(GSPath *)currPath offsetX:(CGFloat)offsetX offsetY:(CGFloat)offsetY makeStroke:(BOOL)makeStroke position:(float)position objects:(NSMutableArray *)returnObjects capStyleStart:(GSLineCapStyle)capStyleStart capStyleEnd:(GSLineCapStyle)capStyleEnd keepCompatibleOutlines:(BOOL)keepCompatible extraHandles:(NSMutableArray *)extraHandles __attribute((deprecated("use method `offsetPath:offsetX:offsetY:makeStroke:position:objects:capStyleStart:capStyleEnd:grid:keepCompatibleOutlines:extraHandles:` instead")));

+ (NSArray *)offsetPath:(GSPath *)currPath offsetX:(CGFloat)offsetX offsetY:(CGFloat)offsetY makeStroke:(BOOL)makeStroke position:(float)position objects:(NSMutableArray *)returnObjects capStyleStart:(GSLineCapStyle)capStyleStart capStyleEnd:(GSLineCapStyle)capStyleEnd grid:(CGFloat)grid keepCompatibleOutlines:(BOOL)keepCompatible extraHandles:(NSMutableArray *)extraHandles;

- (NSString *)input:(NSString *)prompt defaultValue:(NSString *)defaultValue;

@end
